### 概述

SF2210包含了相机源，文件源和视觉算子三个部分：相机源功能可以在工智机和相机直连的情况下实现获取相机的ID并获取相机所拍摄的图片；文件源软件可以实现和工智机的本地图片传输功能，该功能后续集成到IDE中，无需单独下载使用；视觉算子库提供了相机服务算子库、基础视觉算子库和时间序列算子库在MateFacture中调用的接口，这些接口提供了一种可通过ST脚本在PLC工程中实现对相机的操作以及对图像序列的处理

下表概述了各个产品组件

| **产品组件**                                            | **描述说明**                 |
| --------------------------------------------------- | ------------------------ |
| libacp\_0.2.3\_amd64.deb                            | ACP服务组件                  |
| sicomputervisionop\_0.0.0-liandev3c4e95c\_amd64.deb | SF2210(相机源+文件源+视觉算子)服务组件 |
| SF2210\_Vision\_1.0.1.2.library                     | IDE端库文件（相机源+文件源+视觉算子）    |
| SF2210.project                                      | IDE端测试样例文件               |
| FileSource.rar                                      | 文件源软件                    |
| PICS.rar                                            | 测试用例图片                   |


---
### 安装卸载
**安装要求**

* 中科时代出厂的工智机
* 中科时代出厂的相机

**安装过程**

**1、安装ACP服务组件和SF2210服务组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

```Shell
sudo dpkg -i sicomputervisionop\_0.0.0-liandev3c4e95c\_amd64.deb
sudo dpkg -i libacp\_0.2.3\_amd64.deb 
```
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cbe283080.png)


**2、修改RTE的配置文件，ComponentManger模块下加入sicomputervisionop（只需要添加绿色的部分，具体序号需要根据实际情况更改）**
```Shell
sudo vim /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg 
```
```Shell
[ComponentManager]
Component.0=retainDeamon
Component.1=CmpCanBusUtils
Component.2=SinsegyeCmp
Component.3=SF2210
Component.3=sicomputervisionop
```
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cc3fa6eb1.png)

* 重启RTE服务，使新加入的sicomputervisionop被调用

``` Shell
sudo systemctl restart sinsegyerte.service
```

**3、IDE侧部署SF2210的library**

* MetaFacture中点击最上面的菜单栏 ”工具“ -- ”库存储“&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cc4d7f71e.png)

* 弹出的对话窗中点击”安装“ -- 双击SF2210\_Vision\_1.0.1.2.library
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cc54f0e8f.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cc5cd6d76.png)

* 工程中双击“库管理器”  -- “添加库”  --点击杂项 --双击“SF2210\_Vision” ，加载库完成
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cc66a3465.png)

**更新安装**

**1、升级工智机ACP服务组件和SF2210服务组件**

* 上传升级版deb包到工智机Linux环境的/home/sinsegye目录下，上传方法参考附录；

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

```Shell
sudo dpkg -i sicomputervisionop\_0.0.0-liandev3c4e95c\_amd64.deb
sudo dpkg -i libacp\_0.2.3\_amd64.deb 
```
* 重启RTE服务，使新升级的SF2210被调用

```Shell
sudo systemctl restart sinsegyerte.service
```

**2、升级IDE侧SF2210的library**

* MetaFacture中点击最上面的菜单栏“工具”-- “库存储”

* 弹出的对话窗中点击”安装“ -- 选中SF2210\_Vision\_1.0.1.2.library -- 点击“打开”

* 工程中双击“库管理器”  -- “添加库”  --点击杂项 --双击“SF2210\_Vision” ，加载库完成

**卸载过程**

**1、卸载工智机ACP服务组件和SF2210服务组件**

* 工智机上执行命令卸载

```Shell
sudo dpkg -P sicomputervisionop
sudo dpkg -P libacp 
```

* 修改RTE的配置文件，ComponentManger模块下去掉sicomputervisionop

```Shell
sudo vim /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
```
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801ccf5d14d0.png)

* 重启RTE服务
```Shell
sudo systemctl restart sinsegyerte.service 
```

**2、卸载IDE侧SF2210的library**

* MetaFacture界面点击“工具” -- “库存储”&#x20;

* 对话框中选中安装的SF2210\_Vision库，点击“卸载”

---
### 技术说明

**快速启动**

**（一）本例软、硬件配置**


| 硬件：|软件： |
| - | - |
|1. SP7000Se | 1. MetaFacutre V1.0.6.5|
|2. Win11Pc |2. MobaXterm_Personal_23.2 |
| | 3. FileSource|
| | |

**（二）本例实验操作步骤**

 **1 实验要求**

a.工智机成功安装ACP服务组件和SF2210服务组件并正确修改配置文件

b.MetaFacture成功安装库文件SF2210\_vision.library

**2 实验原理图**
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801ce4330e16.png)

**3 实验步骤**

可以参考产品组件中的SF2210.project项目来进行本次实验

**相机源部分**

1.修改工智机网口IP

修改工智机网口（要和相机直连的网口）为固定IP，一般为192.168.1.2001.

设置静态IP，需通过 vim 编辑以下这个 yaml 格式的网络配置文件：

```Shell
sudo vim /etc/netplan/01-network-manager-all.yaml 
```

例子中的配置文件名 01-network-manager-all.yaml 可能与实际环境不同，但此路径下只有一个可修改的同扩展名文件，需根据实际情况处理。

对 yaml 配置文件的修改需要遵守 yaml 的格式标准，如果修改错误则会导致配置不生效。您可以通过该网站 https://www.bejson.com/validators/yaml\_editor/ yaml在线校验工具 对修改进行校验。

```yaml
network:  
version: 2  
renderer: NetworkManager  
ethernets:    
eth0:                                     # 网卡名称      
dhcp4: no                               # 关闭 dhcp 服务      
dhcp6: no      
addresses: \[192.168.110.134/24]         # 静态 ip 和掩码位 
```

\[esc]:wq 保存修改的 yaml 文件，并执行执行以下命令进行检验和生效：

```Shell
sudo netplan generatesudo netplan appl
```

2.相机配置

将以下图片打印后放在相机镜头内
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cef38a4c6.png)

相机和PC网线直连

打开迈德威视网口配置工具，修改相机IP地址，使其网段和工智机要连接的网口一致

[软件下载 : 深圳市迈德威视科技有限公司|常规面阵相机|线阵工业相机|智能相机|特殊相机|工业读码器](https://www.mindvision.com.cn/category/software/)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf00b9d1e.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf073a285.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf0fd5a1a.png)
配置完成以后查看是否能识别图像
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf197cac2.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf21ae45c.png)
3.相机加载和工程配置

相机和工智机网线直连，
```Shell
vsdrv 192.168.110.105（工智机IP）
```
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf442fa7e.png)

弹出enter command后，输入a并回车，如果出现dev sn说明已经连接到相机了，然后再弹出enter command后输入b并回车即可

打开测试工程文件SF2210.project，点击登录并运行，双击camera
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf4c07e65.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf516a182.png)
依次将图中3个变量置true
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf59afaad.png)

点击工具-图像浏览器
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf61816dc.png)

在窗口中选择工智机，窗口，点击运行
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf6a834a6.png)

本程序实现的是识别图片中的二维码并标记
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf734464a.png)

**文件源部分**

1.使用FileSource上传图片到工智机

解压FileSource压缩包并打开FileSource
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf8dc20bf.png)
点击VISION--New FileSource，并输入Name和TargetId（Name可以任意输入，TargetId为工智机IP）
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf96833a2.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cf9e6d024.png)

添加测试图片文件，将图片Fortmat设置为RGB24后，点击send data，成功后会有提示——照片源更新成功
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cfa72fe14.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cfaee81c5.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cfb732713.png)
复制FilesSource中的Object Id，后续工程中需要使用
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cfc08a779.png)

2.工程配置与运行（自动触发）

打开测试工程文件SF2210.project，并修改程序中有关Object Id的变量
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cfd622b71.png)

进入Device选项，选择工智机并登录
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cfe1c392d.png)

点击运行后进入程序中进行如下操作：

①变量set置true，确保objId正确配置
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801cffc096d6.png)

②变量start置true，开启文件源；也可通过FileSource上控制start/stop
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d003b0207.png)

![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d00c7b7b3.png)


③若FileSource中Trigger Mode为false，置变量Get和runstate为true
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d01555d87.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d01ae958b.png)

④点击工具中的图像浏览器两次，并把两个窗口分开
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d026612b1.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d02e62597.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d0367909a.png)

⑤两个窗口都选择目前运行的工智机，其中一个窗口选择为testwindow，另一个窗口选择为originwindow
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d03e8e1f9.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d045dd2c2.png)

⑥两个窗口都点击运行，可以看到原始图像和经过视觉算子处理后的图像，并且图片为每隔500ms自动更换为下一张，本程序实现的是检测图中的圆并标记
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d050c49e5.png)

![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d057797c2.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d06042c35.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d0671fbe2.png)


2.工程配置与运行（手动触发）
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d06f66550.png)


若FileSource中Trigger Mode为true，置变量Get和runstate为true，并点击start sending，通过点击FileSource中的Trigger Image

点击工具中的图像浏览器两次，并把两个窗口分开
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d08eaefec.png)

![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d096bf9cb.png)

![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d09d2f5c0.png)


⑨两个窗口都选择目前运行的工智机，其中一个窗口选择为testwindow，另一个窗口选择为originwindow
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d0a5d52e8.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d0ab6ec52.png)


⑩两个窗口都点击运行，可以看到原始图像和经过视觉算子处理后的图像，并且每次点击FileSource中的Trigger Image，图片都会切换为下一张
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d0b723460.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d0bddf703.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d0c4ed2c9.png)
![](https://resource.helplook.net/docker_production/3648ne/article/L7hlKCJj/6801d0cbdc926.png)

---
#### 示例

| **名称**         | **SF2210版本**                                    | **ACP版本**             | **描述**    |
| -------------- | ----------------------------------------------- | --------------------- | --------- |
| SF2210.project | sicomputervisionop\_0.0.0-liandev3c4e95c\_amd64 | libacp\_0.2.3 \_amd64 | PLC快速启动工程 |